### 66.1. 配置Logback

如果你将一个logback.xml放到classpath根目录下，那它将会被从这加载。Spring Boot提供一个默认的基本配置，如果你只是设置日志级别，那你可以包含它，比如：
```xml
<?xml version="1.0" encoding="UTF-8"?>
<configuration>
    <include resource="org/springframework/boot/logging/logback/base.xml"/>
    <logger name="org.springframework.web" level="DEBUG"/>
</configuration>
```
如果查看spring-boot jar包中的默认logback.xml，你将会看到LoggingSystem为你创建的很多有用的系统属性，比如：
- ${PID}，当前进程id
- ${LOG_FILE}，如果在Boot外部配置中设置了`logging.file`
- ${LOG_PATH}，如果设置了`logging.path`（表示日志文件产生的目录）

Spring Boot也提供使用自定义的Logback转换器在控制台上输出一些漂亮的彩色ANSI日志信息（不是日志文件）。具体参考默认的`base.xml`配置。

如果Groovy在classpath下，你也可以使用logback.groovy配置Logback。
